/*
 * TagTreeDelegate.cpp
 *
 *  Created on: 22.10.2009
 *      Author: stefan.detter
 */

#include "TagTreeDelegate.h"

#include "../data/TreeItem.h"

#include <QApplication>
#include <QStyledItemDelegate>
#include <QStyleFactory>

TagTreeDelegate::TagTreeDelegate(QSortFilterProxyModel* proxy, QObject* parent)
	: QStyledItemDelegate(parent)
	, m_proxy(proxy)
{
#if QT_VERSION_MAJOR == 4
	m_progressbarStyle = QStyleFactory::create("plastique");
#else
	m_progressbarStyle = QStyleFactory::create("fusion");
#endif
}

TagTreeDelegate::~TagTreeDelegate()
{
}


void TagTreeDelegate::paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
	TreeItem* i = static_cast<TreeItem*> (m_proxy->mapToSource(index).internalPointer());
	if ( i != 0 && i->itemType() == TreeItem::INFO && index.column() == 1)
	{
		switch(i->displayType())
		{
			case TreeItem::PROGRESSBAR:
			{
				int progress = index.data().toInt();

				if(progress > i->progressBarMax())
					progress = i->progressBarMax();
				if(progress < i->progressBarMin())
					progress = i->progressBarMin();

				QStyleOptionProgressBar progressBarOption;
				progressBarOption.rect = option.rect;
				//progressBarOption.rect.setWidth(progressBarOption.rect.width() * 2);
				progressBarOption.minimum = i->progressBarMin();
				progressBarOption.maximum = i->progressBarMax();
				progressBarOption.progress = progress;
				progressBarOption.text = i->progressBarText().arg(progress);
				progressBarOption.textVisible = true;

				m_progressbarStyle->drawControl(QStyle::CE_ProgressBar, &progressBarOption, painter);

				return;
			}
		default:
			break;
		}
	}

	QStyledItemDelegate::paint(painter, option, index);
}

